#ifndef __CEndian__
#define __CEndian__

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @class CEndian CEndian.hpp
		 * @brief Endian conversion routines and byte swapping
		 *
		 * @date 09/04/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CEndian.hpp,v 1.5 2007/02/08 21:06:44 paul Exp $
		 */
		class CEndian
		{
		public:

//	===========================================================================

			/**
			 * @enum EEndian
			 * @brief Enurmeration of endianess
			 */
			enum EEndian
			{
				e_littleEndian = 0,			/**< Little endian systems, INTEL WIN32 MACOSX_UNIBIN */
				e_bigEndian,				/**< Big endian, MACOSX */
			};

//	===========================================================================

			/**
			 * Get the endianness of a system at run time
			 * @retval EEndian The endianess of the system
			 */
			static CEndian::EEndian getSystemEndianessRunTime();

			/**
			 * Get the endianness of a system at compile time
			 * @retval EEndian The endianess of the system
			 */
			static CEndian::EEndian getSystemEndianessCompileTime();

//	===========================================================================

			/**
			 * Convert three bytes to a 24 bit int, uses full 32 bit integer range
			 * @param bytes The three data bytes
			 * @retval int The 24 bit int value, in range -0x80000000 to 0x7fffffff
			 */
			static int convertThreeBytesToTwentyFourBitInt(const char *bytes);

			/**
			 * Convert three bytes to a 24 bit int, uses full 32 bit integer range
			 * @param value The value to convert in range  -0x80000000 to 0x7fffffff
			 * @param bytes The three data bytes
			 */
			static void convertTwentyFourBitIntToThreeBytes(const int value, char *bytes);
			 
			/**
			 * Swap the bytes if we are a big endian system
			 * @param bytes The data bytes
			 * @retval unsigned short The data bytes swap if big endian
			 */
			static unsigned short swapDataBytesIfSystemIsBigEndian(unsigned short bytes);

			/**
			 * Swap the bytes if we are a big endian system
			 * @param bytes The data bytes
			 * @retval unsigned int The data bytes swap if big endian
			 */
			static unsigned int swapDataBytesIfSystemIsBigEndian(unsigned int bytes);

			/**
			 * Swap 2 bytes
			 * @param buffer Pointer to two chars that is swapped
			 */
			static void swap2Bytes(unsigned char *buffer);

			/**
			 * Swap four bytes if system is little endian
			 * @param buffer Pointer to two chars that is swapped, expected to be 4 bytes long
			 */
			static void swapFourBytesIfSystemIsLittleEndian(unsigned char *buffer);

//	===========================================================================
		};
	}
}
#endif	// End of CEndian.hpp